/** @file   AnimId.h
 * @brief   Declaration of AnimId class.
 * @version $Revision: 1.9 $
 * @date    $Date: 2006/06/21 16:10:30 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ANIMID_H
#define H_WWW_ANIMID_H


namespace WeWantWar {

/** @class  AnimId
 * @brief   Contains the id codes for the animations.
 * @author  Tomi Lamminsaari
 *
 */
class AnimId
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  // Players
  static const int KPlayerCrowbar = 1;
  static const int KPlayerRifle = 2;
  static const int KPlayerUzi = 3;
  static const int KPlayerMinigun = 4;
  static const int KPlayerLauncher = 5;
  
  // Aliens
  static const int KCarnivoreAlien = 20;
  static const int KSmallWormAlien = 21;
  static const int KWingedAlien = 22;
  static const int KProctorAlien = 23;
  static const int KPredatorAlien = 24;
  static const int KMediumWormAlien = 25;
  static const int KFlamerAlien = 26;
  static const int KLightballAlien = 27;
  static const int KMinigunAlien = 28;
  static const int KSentrygun1 = 29;
  static const int KSentrygun2 = 30;
  static const int KFighterAlien = 31;
  static const int KStarGate = 32;
  static const int KBadAssAlien = 33;
  static const int KHiddenWormAlien = 34;
  static const int KSlimeAlien = 35;
  
  // Other game objects
  static const int KRedWasteBarrel = 100;
  static const int KRollingBarrel = 101;
  
  ///
  /// Decorative animations.
  ///
  static const int KDecorativeFountain = 200;
  static const int KDecorativeChair1 = 201;
  static const int KDecorativeChair2 = 202;
  static const int KDecorativeLaptop = 203;
  static const int KDecorativeMicrowaveOven = 204;
  static const int KDecorativeMiniHouse = 205;
  static const int KDecorativeMonitor = 206;
  static const int KDecorativeChair3 = 207;
  static const int KDecorativeTelevision = 208;
  
  // Graphic effects.
  static const int KEffectFraction = 300;
  static const int KEffectSewerPlate1 = 301;
  static const int KEffectSewerPlate2 = 302;
  static const int KScoresAnimations = 303;
  static const int KComboLabels = 304;
  static const int KEffectSewerPlate3 = 305;
  
  // Civilian animations
  static const int KCivilian1 = 400;
  static const int KCivilian2 = 401;
  static const int KCivilian3 = 402;
  static const int KCivilian4 = 403;
  static const int KCivilian5 = 404;
  static const int KCivilian6 = 405;
  static const int KCivilianDancer1 = 406;
  static const int KCivilianDancer2 = 407;
  static const int KEric = 408;
  static const int KSimon = 409;
  static const int KYouko = 410;
  static const int KArmedYouko = 411;
  
  // Weapon effects
  static const int KBulletAlienFireball = 500;
  static const int KBulletRocket = 501;
  static const int KEffectBulletMotion = 502;
  static const int KEffectBulletShell = 503;
  static const int KEffectGrenadeLight = 504;
  static const int KEffectRocketSmoke = 506;
  static const int KMines = 512;
  static const int KBulletAlienFireball2 = 520;
  static const int KEffectBulletMotion2 = 521;
  
  ///
  /// Fire and explosion animations.
  ///
  static const int KExplosionGrenade = 507;
  static const int KExplosionRocketLauncher = 508;
  static const int KExplosionSmallWorm = 509;
  static const int KFireFlameThrower = 510;
  static const int KRifleShootFlame = 511;
  static const int KShotgunShootFlame = 515;
  static const int KMinigunShootFlame = 516;
  static const int KUziShootFlame = 517;
  static const int KCampFire = 518;
  static const int KForceField = 519;
  static const int KExplosionLightRing = 530;
  
  ///
  /// Light and Shadow effects
  ///
  static const int KRifleShotLight = 600;
  static const int KSmallWormShootLight = 601;
  static const int KGrenadeExplosionLight = 602;
};

};  // end of namespace

#endif
